package gov.va.caret.pm.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.servlet.http.HttpServletRequest;

import gov.va.caret.model.PMMessage;
import gov.va.caret.security.CAction;
import gov.va.caret.security.CAction.CaretCan;
import gov.va.caret.service.PersnLocalServiceUtil;

import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.GroupConstants;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.UserGroupLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;

public class PMUtil {

	public static Set<User> getRecepientsList(String recepients) {
		Set<User> list = new HashSet<User>();
		String[] ids = recepients.split(",");
		for (int i = 0; i < ids.length; i++) {
			String nextId = ids[i];
			if (nextId.contains(PMConstants.ALL_USERS)) {
				//Support old code
			} else if (nextId.contains(PMConstants.ALL_MEMBERS)) {
				String communityIdStr = nextId.substring(PMConstants.ALL_MEMBERS.length());
				long communityId = Long.parseLong(communityIdStr);
				try {
					list.addAll(UserLocalServiceUtil.getGroupUsers(communityId));
				} catch (SystemException e) {
					e.printStackTrace();
				}
			} else {
				try {
					long userId = Long.parseLong(ids[i]);
					list.add(UserLocalServiceUtil.getUser(userId));
				} catch (PortalException e) {
					e.printStackTrace();
				} catch (SystemException e) {
					e.printStackTrace();
				}
			}
		}
		return list;
	}
	public static Long[] getRecipentsForQuery(String recepients) {
		String[] ids = recepients.split(",");
		Long[] recepientIds = new Long[ids.length];
		for (int i = 0; i < ids.length; i++) {
			recepientIds[i] = Long.parseLong(ids[i]);
		}
		return recepientIds;
	}
	public static String getRecepientsAsString(PMMessage message) {
		String str = "";

		String recepients = message.getRecepients();
		Group community = null;
		User user = null;
		String[] ids = recepients.split(",");
		for (int i = 0; i < ids.length; i++) {
			String nextId = ids[i];
			if (nextId.contains(PMConstants.ALL_USERS)) {
				//Support old code
			} else if (nextId.contains(PMConstants.ALL_MEMBERS)) {
				String communityIdStr = nextId.substring(PMConstants.ALL_MEMBERS.length());
				long communityId = Long.parseLong(communityIdStr);
				try {
					community = GroupLocalServiceUtil.getGroup(communityId);
					if (i > 0) {
						str += ", ";
					}
					str += PMConstants.ALL_MEMBERS+"-"+community.getName();
				} catch (PortalException e) {
					e.printStackTrace();
				} catch (SystemException e) {
					e.printStackTrace();
				}					
			} else {
				long userId = Long.parseLong(ids[i]);
				try {
					user = UserLocalServiceUtil.getUser(userId);
					if (i > 0) {
						str += ", ";
					}
					str += user.getFullName();
				} catch (PortalException e) {
					e.printStackTrace();
				} catch (SystemException e) {
					e.printStackTrace();
				}					
			}
		}
		
		return str;
	}
	
	public static boolean isMessageReadForUser(PMMessage message, Long userId) {
		String recepients = message.getReadRecepients();
		if (recepients.contains(Long.toString(userId))) {
			return true;
		}
		return false;
	}

	public static String getSenderEmail(PMMessage message) {
		long ownerId = message.getOwnerId();
		try {
			return UserLocalServiceUtil.getUserById(ownerId).getEmailAddress();
		} catch (PortalException e) {
			e.printStackTrace();
		} catch (SystemException e) {
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * Returns all active users
	 * 
	 * @return
	 */
	public static List<User> getAllUsers(RenderRequest request) {
		List<User> users = new ArrayList<User>();
		CaretCan caretCan = CaretCan.INTERNAL_MESSAGE;
		
		List<Group> communities = new ArrayList<Group>();
		try {
			users = UserLocalServiceUtil.getUsers(0, UserLocalServiceUtil.getUsersCount());
			List<User> filtered = new ArrayList<User>();
			for (User u : users) {
				//u.getGroup().getGroupId();
				List<Group> userGroups =  GroupLocalServiceUtil.getUserGroups(u.getUserId());
						//PersnLocalServiceUtil.getByUser(u.getUserId()).getGroupId();
				for (Group userGroup : userGroups) {
					if (u.isActive() && CAction.canDoCaret(request, caretCan, userGroup.getGroupId())) {
						//.canDoCaret((PortletRequest)request, CAction.CaretCan.INTERNAL_MESSAGE)) {  
					filtered.add(u);
					communities.add(userGroup);
					break;
				}
				}
			}
			users = filtered;
		} catch (SystemException e) {
			e.printStackTrace();
		}
		return users;
	}

	/**
	 * Returns all existing communities
	 * 
	 * @return
	 * @throws Exception
	 */
	public static List<Group> getAllCommunities(RenderRequest request) {
		List<Group> communities = new ArrayList<Group>();
		CaretCan caretCan = CaretCan.INTERNAL_MESSAGE;
		try {
			List<Group> groups = GroupLocalServiceUtil.search(
					 	PortalUtil.getCompanyId(request), null, null, 
					    null, QueryUtil.ALL_POS, QueryUtil.ALL_POS);
			
			//List<Group> groups = GroupLocalServiceUtil.getLiveGroups();
			for (Group g : groups) {
				if (CAction.canDoCaret(request, caretCan, g.getGroupId())) {
					communities.add(g);
				}
			}
		} catch (SystemException e) {
			e.printStackTrace();
		} /*catch (PortalException e) {
            e.printStackTrace();
        }*/
		return communities;
	}
}